// Code adapted from lennyjpg's: https://www.shadertoy.com/view/XscfzB

vec3 zebra(vec2 uv) {
    float t = time.current * .004;
    float g = 3.1;
    vec2 center = vec2(
        sin(uv.y * g + t + time.current),
        cos(uv.x * g + t)
    );
    float d = distance(uv, center);
	float k = -sin(d*6.283*10. - t);
	float e = smoothstep(0., fwidth(k)*0.5, k);
    return vec3(sqrt(max(e, 0.))) * smokeParams.smokeColor.xyz;
}
